﻿using Nova.Models;
using Nova.Models.IngresoPersonal;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Transactions;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers.IngresoPersonal
{
    public class SeleccionController : BaseController
    {
        bdNovaEntities db = new bdNovaEntities();
        // GET: Seleccion
        [AllowAnonymous]
        [OutputCache(Duration = 0)]
        public ActionResult Index(string token)
        {
            Kardex_SolicitudEvaluaciones model = new Kardex_SolicitudEvaluaciones();

            model= Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            ViewBag.IdKardex = model.IdKardexCandidato;

            List<Kardex_stAspiranteProceso> tareas = db.Kardex_stAspiranteProceso.Where(q => q.IdKardexSolicitudEvaluacion == model.IdKardexSolicitudEvaluacion).OrderBy(a => a.Tarea).ToList();
            Kardex_CitasContratacion cita = db.Kardex_CitasContratacion.Where(q => q.CicloEscolar.Replace(" ","")==model.CicloEscolar.Replace(" ","")  
            && q.IdKardexSolicitudEvaluacion == model.IdKardexSolicitudEvaluacion).FirstOrDefault();


            Kardex_SolicitudEvaluacionesDto data = new Kardex_SolicitudEvaluacionesDto(model);
            data.TareasTerminadas = tareas;

            if (cita != null)
            {
                data.TieneCita = true;
                data.FechaCita = cita.FechaCita;
                data.HoraCita= cita.HoraCita;
            }

            ViewBag.token = token;
            

                return View(data);
        }

        [AllowAnonymous]
        public JsonResult GetAvailableHours(string fechaCita)
        {
            var f = DateTime.Parse(fechaCita);
            var citasEnFecha = db.Kardex_CitasContratacion.Where(c => c.FechaCita == f).ToList();

            var horasOcupadas = citasEnFecha.Select(c => c.HoraCita.ToString(@"h\:mm")).ToList();

            return Json(horasOcupadas, JsonRequestBehavior.AllowGet);
        }

        [AllowAnonymous]
        public JsonResult EditarDatosPersonales(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            try
            {
                var t = Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(model.IdKardexSolicitudEvaluacion, AspiranteTareasContratacion.DatosPersonales);

            }
            catch (Exception ex)
            {

                return JsonView(false, ex.GetOriginalException().Message);

            }
            return JsonView(true, "Datos personales actualizados exitosamente");

        }

        [AllowAnonymous]
        public JsonResult InformacionDigital(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            try
            {
                var t = Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(model.IdKardexSolicitudEvaluacion, AspiranteTareasContratacion.ExpedienteDigital);

            }
            catch (Exception ex)
            {

                return JsonView(false, ex.GetOriginalException().Message);

            }
            return JsonView(true, "Infdrmacion digital actualizada exitosamente");

        }

        [AllowAnonymous]
        public JsonResult DescargarFormatoSeguro(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            try
            {
                var t = Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(model.IdKardexSolicitudEvaluacion, AspiranteTareasContratacion.FormatoSeguroVida);

            }
            catch (Exception ex)
            {

                return JsonView(false, ex.GetOriginalException().Message);

            }
            return JsonView(true, "Formato de seguro de vida descargado");

        }

        [AllowAnonymous]
        public JsonResult EditarDatosAcademicos(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            try
            {
                var t = Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(model.IdKardexSolicitudEvaluacion, AspiranteTareasContratacion.DatosAcademicos);

            }
            catch (Exception ex)
            {

                return JsonView(false, ex.GetOriginalException().Message);

            }
            return JsonView(true, "Datos Academicos actualizados exitosamente");

        }

        [AllowAnonymous]
        public JsonResult InformacionAdicional(string token)
        {
            var model = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);
            try
            {
                var t = Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(model.IdKardexSolicitudEvaluacion, AspiranteTareasContratacion.InformacionAdicional);

            }
            catch (Exception ex)
            {

                return JsonView(false, ex.GetOriginalException().Message);

            }
            return JsonView(true, "Informacion adiconal actualizada exitosamente");

        }

        [AllowAnonymous]

        public ActionResult CrearCita(string token)
        {
            int id=0;
            var datos = Nova.Models.IngresoPersonal.IngresoPersonal.ObtenKardexSolicitudEvaluaciones(token);


            Kardex_CitasContratacionDto model = new Kardex_CitasContratacionDto();
            model.IdKardexSolicitudEvaluacion = datos.IdKardexSolicitudEvaluacion;
            model.CicloEscolar= datos.CicloEscolar;

            var control = db.Nomina_ContratosConfiguracion.Where(q=> q.CicloEscolar==datos.CicloEscolar).FirstOrDefault();
            if (control == null)
                throw new ApplicationException("No hay fechas aun configuradas para iniciar el proceso");
                
            
            // Aquí podrías cargar datos adicionales, si es necesario, como la lista de trabajadores disponibles
            DateTime fechaInicio = control.FechaInicioContrato.AddDays(-5);
            DateTime fechaFin = control.FechaInicioContrato.AddDays(60);

            DateTime hoy = DateTime.Today;

            var fechasDisponibles = new List<string>();
            DateTime fechaActual = fechaInicio;
            var diasExcluidos = new List<DateTime>
                {
                    new DateTime(2023, 8, 21),
                    new DateTime(2023, 8, 22)
                };

            while (fechaActual <= fechaFin)
            {
                if (!diasExcluidos.Contains(fechaActual.Date) && fechaActual.DayOfWeek != DayOfWeek.Saturday && fechaActual.DayOfWeek != DayOfWeek.Sunday && fechaActual >= hoy)
                {
                    fechasDisponibles.Add(fechaActual.ToString("dd/MM/yyyy"));
                }


                fechaActual = fechaActual.AddDays(1);
            }

            // Creamos el SelectList con las fechas disponibles y lo asignamos a una ViewBag
            ViewBag.FechasDisponibles = new SelectList(fechasDisponibles);

            return View(model);
        }

        [AllowAnonymous]
        // Acción para procesar el formulario de creación de citas
        [HttpPost]
        public JsonResult CrearCita(Kardex_CitasContratacionDto cita)
        {
            cita.FechaRegistro = DateTime.Now;
            cita.FechaUltimaModificacion = DateTime.Now;
            Kardex_CitasContratacion model = new Kardex_CitasContratacion();

            model.CicloEscolar = cita.CicloEscolar;
            model.IdKardexSolicitudEvaluacion = cita.IdKardexSolicitudEvaluacion;
            model.FechaCita = cita.FechaCita;
            model.HoraCita = cita.HoraCita;
            model.FechaRegistro = cita.FechaRegistro;
            model.FechaUltimaModificacion = cita.FechaUltimaModificacion;

            

            if (ModelState.IsValid)
            {

                // Verificar que el trabajador no tenga otra cita para el mismo ciclo escolar en la misma fecha
                var citaDuplicada = db.Kardex_CitasContratacion.Where(c =>
                    c.IdKardexSolicitudEvaluacion == cita.IdKardexSolicitudEvaluacion &&
                    c.CicloEscolar == cita.CicloEscolar
                   ).FirstOrDefault();

                if (citaDuplicada!=null)
                {
                    // ModelState.AddModelError("", "El trabajador ya tiene una cita para este ciclo escolar en la misma fecha.");
                return JsonView(false, $"Ya tienes una cita para este ciclo escolar en fecha {citaDuplicada.FechaCita.ToString("dd/MM/yyyy")} a las {citaDuplicada.HoraCita}");

                }

                var citaDuplicadahora = db.Kardex_CitasContratacion.Where(c =>
                    c.FechaCita==cita.FechaCita && c.HoraCita==cita.HoraCita
                    && c.CicloEscolar == cita.CicloEscolar
                   ).FirstOrDefault();

                if (citaDuplicada != null)
                {
                    // ModelState.AddModelError("", "El trabajador ya tiene una cita para este ciclo escolar en la misma fecha.");
                    return JsonView(false, $"Ya existe una cita reservada por alguien mas, para este ciclo escolar en fecha {citaDuplicada.FechaCita.ToString("dd/MM/yyyy")} a las {citaDuplicada.HoraCita}, elige otro horario.");

                }
                // Verificar que la hora de la cita esté dentro del horario permitido (de 8 am a 5 pm)
                // Verificar que la hora de la cita esté dentro del horario permitido (de 8 am a 5 pm)
                int horaInicio = 8;
                int horaFin = 17;

                if (cita.HoraCita.Hours < horaInicio || cita.HoraCita.Hours >= horaFin)
                {
                    // ModelState.AddModelError("", "La hora de la cita debe estar entre las 8 am y las 5 pm.");
                    JsonView(false, "La hora de la cita debe estar entre las 8 am y las 5 pm.");

                }
                // Guardar la cita en la base de datos
               
            cita.FechaRegistro = DateTime.Now;
                try
                {
                    TransactionOptions transactionoptions1 = new TransactionOptions();
                    transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;

                    using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                    {


                        var solicitudeval =db.Kardex_SolicitudEvaluaciones.Find(cita.IdKardexSolicitudEvaluacion);


                       

                      

                        solicitudeval.IdEstatusContratacion = 5;

                        db.Entry(solicitudeval).State = EntityState.Modified;

                      

                        db.SaveChanges();



                        db.Entry(model).State = EntityState.Added;
                        db.Kardex_CitasContratacion.Add(model);
                      db.SaveChanges();


                        var t = Nova.Models.IngresoPersonal.IngresoPersonal.guardaTareaTerminada(model.IdKardexSolicitudEvaluacion, AspiranteTareasContratacion.Cita);
                   
                    

                        Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailConfirmacionCita(model.IdKardexSolicitudEvaluacion);
                        scope.Complete();
                        return JsonView(true, "La cita fue agregada con exito");

                    }
                }
                catch (Exception es)
                {

                    return JsonView(false, es.Message);

                }

             
                // Redireccionar a la página de éxito o a otra acción de tu elección

            }
            else
            {
                return JsonView(false, string.Join(", ", ModelState.Values
         .SelectMany(v => v.Errors)
         .Select(e => e.ErrorMessage)));

            }
        }

    }
}